---
description: "Learn more about: Time intelligence functions"
title: "Time intelligence functions (DAX) | Microsoft Docs"
---
# Time intelligence functions

Data Analysis Expressions (DAX) includes time-intelligence functions that enable you to manipulate data using time periods, including days, months, quarters, and years, and then build and compare calculations over those periods. Before using any time-intelligence functions, make sure to mark one of the tables containing date column as Date Table.
  
## In this category

|Function  |Description  |
|---------|---------|
|[CLOSINGBALANCEMONTH](closingbalancemonth-function-dax.md)      |  Evaluates the expression at the last date of the month in the current context.       |
|[CLOSINGBALANCEQUARTER](closingbalancequarter-function-dax.md)       | Evaluates the expression at the last date of the quarter in the current context.          |
|[CLOSINGBALANCEYEAR](closingbalanceyear-function-dax.md)      |  Evaluates the expression at the last date of the year in the current context.       |
|[DATEADD](dateadd-function-dax.md)      |  Returns a table that contains a column of dates, shifted either forward or backward in time by the specified number of intervals from the dates in the current context.       |
|[DATESBETWEEN](datesbetween-function-dax.md)      |   Returns a table that contains a column of dates that begins with a specified start date and continues until a specified end date.        |
|[DATESINPERIOD](datesinperiod-function-dax.md)      |  Returns a table that contains a column of dates that begins with a specified start date and continues for the specified number and type of date intervals.     |
|[DATESMTD](datesmtd-function-dax.md)      |  Returns a table that contains a column of the dates for the month to date, in the current context.         |
|[DATESQTD](datesqtd-function-dax.md)      |  Returns a table that contains a column of the dates for the quarter to date, in the current context.         |
|[DATESYTD](datesytd-function-dax.md)      |  Returns a table that contains a column of the dates for the year to date, in the current context.        |
|[ENDOFMONTH](endofmonth-function-dax.md)    | Returns the last date of the month in the current context for the specified column of dates.          |
|[ENDOFQUARTER](endofquarter-function-dax.md)      |  Returns the last date of the quarter in the current context for the specified column of dates.         |
|[ENDOFYEAR](endofyear-function-dax.md)     | Returns the last date of the year in the current context for the specified column of dates.        |
|[FIRSTDATE](firstdate-function-dax.md)     | Returns the first date in the current context for the specified column of dates.         |
|[FIRSTNONBLANK](firstnonblank-function-dax.md)     | Returns the first value in the column, column, filtered by the current context, where the expression is not blank        |
|[LASTDATE](lastdate-function-dax.md)      |  Returns the last date in the current context for the specified column of dates.       |
|[LASTNONBLANK](lastnonblank-function-dax.md)      |  Returns the last value in the column, column, filtered by the current context, where the expression is not blank.       |
|[NEXTDAY](nextday-function-dax.md)      |  Returns a table that contains a column of all dates from the next day, based on the first date specified in the dates column in the current context.       |
|[NEXTMONTH](nextmonth-function-dax.md)     |  Returns a table that contains a column of all dates from the next month, based on the first date in the dates column in the current context.       |
|[NEXTQUARTER](nextquarter-function-dax.md)     |  Returns a table that contains a column of all dates in the next quarter, based on the first date specified in the dates column, in the current context.        |
|[NEXTYEAR](nextyear-function-dax.md)      | Returns a table that contains a column of all dates in the next year, based on the first date in the dates column, in the current context.          |
|[OPENINGBALANCEMONTH](openingbalancemonth-function-dax.md)     | Evaluates the expression at the first date of the month in the current context.         |
|[OPENINGBALANCEQUARTER](openingbalancequarter-function-dax.md)     | Evaluates the expression at the first date of the quarter, in the current context.         |
|[OPENINGBALANCEYEAR](openingbalanceyear-function-dax.md)       |  Evaluates the expression at the first date of the year in the current context.       |
|[PARALLELPERIOD](parallelperiod-function-dax.md)     |  Returns a table that contains a column of dates that represents a period parallel to the dates in the specified dates column, in the current context, with the dates shifted a number of intervals either forward in time or back in time.       |
|[PREVIOUSDAY](previousday-function-dax.md)      | Returns a table that contains a column of all dates representing the day that is previous to the first date in the dates column, in the current context.        |
|[PREVIOUSMONTH](previousmonth-function-dax.md)     |  Returns a table that contains a column of all dates from the previous month, based on the first date in the dates column, in the current context.       |
|[PREVIOUSQUARTER](previousquarter-function-dax.md)      |  Returns a table that contains a column of all dates from the previous quarter, based on the first date in the dates column, in the current context.       |
|[PREVIOUSYEAR](previousyear-function-dax.md)       |  Returns a table that contains a column of all dates from the previous year, given the last date in the dates column, in the current context.        |
|[SAMEPERIODLASTYEAR](sameperiodlastyear-function-dax.md)     |  Returns a table that contains a column of dates shifted one year back in time from the dates in the specified dates column, in the current context.       |
|[STARTOFMONTH](startofmonth-function-dax.md)     | Returns the first date of the month in the current context for the specified column of dates.          |
|[STARTOFQUARTER](startofquarter-function-dax.md)     |  Returns the first date of the quarter in the current context for the specified column of dates.         |
|[STARTOFYEAR](startofyear-function-dax.md)     |  Returns the first date of the year in the current context for the specified column of dates.       |
|[TOTALMTD](totalmtd-function-dax.md)      |  Evaluates the value of the expression for the month to date, in the current context.       |
|[TOTALQTD](totalqtd-function-dax.md)     |  Evaluates the value of the expression for the dates in the quarter to date, in the current context.       |
|[TOTALYTD](totalytd-function-dax.md)     | Evaluates the year-to-date value of the expression in the current context.       |
